1. Your shell forks multiple child processes when executing piped commands. How does your implementation ensure that all child processes complete before the shell continues accepting user input? What would happen if you forgot to call waitpid() on all child processes?

_My implementation makes sure this doesn't happen by calling waitpid() on each child process after it has been forked. If I had forgot to do this, this may have led to zombie processes and resource leaks from the child because it won't terminate properly._

2. The dup2() function is used to redirect input and output file descriptors. Explain why it is necessary to close unused pipe ends after calling dup2(). What could go wrong if you leave pipes open?

_It is necessary to close unused pipes to prevent resource leakage because if you don't, it will burn resources for no reason._

3. Your shell recognizes built-in commands (cd, exit, dragon). Unlike external commands, built-in commands do not require execvp(). Why is cd implemented as a built-in rather than an external command? What challenges would arise if cd were implemented as an external process?

_If we were to treat cd as an external command, it would cd the child process instead of the parent, which means we basically wouldn't be cd'ing anything at all since when the child process terminates, the parent shell is still in the original directory._

4. Currently, your shell supports a fixed number of piped commands (CMD_MAX). How would you modify your implementation to allow an arbitrary number of piped commands while still handling memory allocation efficiently? What trade-offs would you need to consider?

_I could modify my implementation by using dynamic lists instead of a fixed number. However, if we were to do that, we would potentially be needing a lot of memory if the person typing in the shell decides to put in a large number of commands constantly. This would also lead to some complexity within the code because you now would need to deal with your shell having to go through several more commands at once than what you might have built the shell for._
