#!/usr/bin/env bats

# File: student_tests.sh
# 
# Create your unit tests suit in this file

@test "Example: check ls runs without errors" {
    	run ./dsh <<EOF                
ls
EOF

    	# Assertions
    	[ "$status" -eq 0 ]
}

@test "Exit Command works" {
	run ./dsh <<EOF
exit
EOF
    	# Assertions
    	[ "$status" -eq 0 ]
}

@test "Multiple commands via pipes are run properly" {
	run ./dsh <<EOF
ls | ls
exit
EOF
	# Assertions
	[ "$status" -eq 0 ]
}

@test "No command is given" {
	run ./dsh <<EOF

exit
EOF

	# Strip all whitespace (spaces, tabs, newlines) from the output
	stripped_output=$(echo "$output" | tr -d '[:space:]')

	# Expected output with all whitespace removed for easier matching
	expected_output="dsh3>warning:nocommandsprovideddsh3>"

	echo "Captured stdout:"
	echo "Output: $stripped_output"
	echo "Expected: $expected_output"
	echo "Exit Status: $status"

	# Check exact match
	[ "$stripped_output" = "$expected_output" ]

	# Assertions
	[ "$status" -eq 0 ]
}

@test "Check if built in cd command works correctly" {
	run ./dsh <<EOF
cd ..
pwd
EOF
	# Assertions
	[ "$status" -eq 0 ]
}

@test "Check error handling for too many pipes" {
	run ./dsh <<EOF
ls | grep dshlib.c | grep armed | grep and | grep dangerous | grep again | grep again | grep again | grep again
exit
EOF

        # Strip all whitespace (spaces, tabs, newlines) from the output
        stripped_output=$(echo "$output" | tr -d '[:space:]')

        # Expected output with all whitespace removed for easier matching
        expected_output="dsh3>error:pipinglimitedto8commandsdsh3>"

        echo "Captured stdout:"
        echo "Output: $stripped_output"
        echo "Expected: $expected_output"
        echo "Exit Status: $status"

        # Check exact match
        [ "$stripped_output" = "$expected_output" ]

        # Assertions
        [ "$status" -eq 0 ]
}

@test "Check if > works" {
        run ./dsh <<EOF
echo "hello, class" > out.txt
cat out.txt
rm out.txt
exit
EOF

        # Strip all whitespace (spaces, tabs, newlines) from the output
        stripped_output=$(echo "$output" | tr -d '[:space:]')

        # Expected output with all whitespace removed for easier matching
        expected_output="\"hello,class\"dsh3>dsh3>dsh3>dsh3>"

        echo "Captured stdout:"
        echo "Output: $stripped_output"
        echo "Expected: $expected_output"
        echo "Exit Status: $status"

        # Check exact match
        [ "$stripped_output" = "$expected_output" ]

        # Assertions
        [ "$status" -eq 0 ]
}

@test "Check if >> works" {
        run ./dsh <<EOF
echo "hello, class" > out.txt
cat out.txt
echo "this is the second line" >> out.txt
cat out.txt
rm out.txt
exit
EOF

        # Strip all whitespace (spaces, tabs, newlines) from the output
        stripped_output=$(echo "$output" | tr -d '[:space:]')

        # Expected output with all whitespace removed for easier matching
        expected_output="\"hello,class\"\"hello,class\"\"thisisthesecondline\"dsh3>dsh3>dsh3>dsh3>dsh3>dsh3>"

        echo "Captured stdout:"
        echo "Output: $stripped_output"
        echo "Expected: $expected_output"
        echo "Exit Status: $status"
                                                                                                                                        
        # Check exact match                                                                                                             
        [ "$stripped_output" = "$expected_output" ]                                                                                     
                                                                                                                                        
        # Assertions                                                                                                                    
        [ "$status" -eq 0 ]                                                                                                             
}
