// Program:	BookCatalog.java
// Purpose: This program simulates a bookstore catalog.
// Author:	Brian Vojtko	
// Date:	12/4/2018

package HW8;
import java.util.ArrayList;

public class BookCatalog {

	//Linked list node to store book information
	class BookStoreNode
	{
		Book book;
		BookStoreNode next;
	}
		//Starting book node in the list
		BookStoreNode startBook;
		//Constructor
		BookCatalog()
		{
			startBook=null;
		}
	
//Add book
public void addBook(String code, String title, String author, int pages, double price, int qty, int qtyLeft)
	{

	if(startBook==null)
	{
		startBook=new BookStoreNode();
		startBook.book=new Book(code,title,author,pages,price,qty,qtyLeft);

	startBook.next=null;
	}

	else
	{
		BookStoreNode temp=startBook;
		BookStoreNode newBook=new BookStoreNode();
		newBook.book=new Book(code,title,author,pages,price,qty,qtyLeft);
		newBook.next=null;
	
	while(temp.next!=null)
	{
		temp=temp.next;
	}
		temp.next=newBook;
	}

}

public Book returnTitle(String sold)
{
	BookStoreNode temp=startBook;

		while(temp!=null)
			{
				if(sold.equals(((Book) temp.book).getTitle()))
					return temp.book;
					temp=temp.next;
			}
			return null;
}

public String toString()
	{
		String allBooks="";
		BookStoreNode temp=startBook;

		while(temp!=null)
		{
			allBooks+=temp.book.toString();
			temp=temp.next;
		}

		return allBooks;
	}
public String soldBook()
{
	String allBooks1="";
	BookStoreNode temp=startBook;

	while(temp!=null)
	{
		allBooks1+=temp.book.soldBook();
		temp=temp.next;
	}

	return allBooks1;
}
}
