// Program:	BookCatalogMain.java
// Purpose: This program simulates a bookstore catalog.
// Author:	Brian Vojtko	
// Date:	12/4/2018
package HW8;
import java.util.Scanner;
import java.io.*;
import java.text.DecimalFormat;
import java.util.*;

public class BookCatalogMain {

	public static void main(String[] args) {
		
		Scanner input = new Scanner(System.in);
		BookCatalog catalog = new BookCatalog();
		String title = "";
		String code = "";
		String author = "";
		int pages= 0;
		double price = 0;
		int qty = 0;
		int qtyLeft = 0;
		boolean redo = true;
		int sold = 0;
		int sum = 0;
		DecimalFormat df = new DecimalFormat("#.00");
		List<String> list = new ArrayList();

		//Intro Interface
		System.out.println("          CS 570 Bookstore");
		System.out.println("---------------------------------------");
		
	//User Prompt
	do
	{
		System.out.println("Enter an ISBN or 000 to stop: ");
		code=input.nextLine();
			if (code.equals("000"))
			{
				//Book Catalog Interface
				System.out.println("                                             Current Catalog");
				System.out.println("-------------------------------------------------------------------------------------------------------------");
				System.out.println("ISBN\t\t\tTitle\t\t\tAuthor\t\tPages\t\tPrice\t\tIn Stock");
				System.out.println("-------------------------------------------------------------------------------------------------------------");
				System.out.println(catalog.toString());
				
				System.out.println("");
				System.out.println("Copies Sold This Week");
				System.out.println("-----------------------------------------------");
				
				for (String item : list)
				{
				System.out.println("Enter the number of copies sold for " + item + ": ");
				sold=input.nextInt();
				sum+= sold;
				
					while (sold < 0)
					{
						System.out.println("You can not enter a negative value. Try again.");
						sold=input.nextInt();
						continue;
					}
				}
				
				System.out.println("                                              Current Catalog");
				System.out.println("-------------------------------------------------------------------------------------------------------------");
				System.out.println("ISBN\t\t\tTitle\t\t\tAuthor\t\tPages\t\tPrice\t\tIn Stock");
				System.out.println("-------------------------------------------------------------------------------------------------------------");
				System.out.println(catalog.soldBook());
				
				System.out.println("Total number of books sold this week: " + (sum));
				double gross = (sum*price);
				System.out.println("Gross sales this week: $" + df.format(gross));
				
				break;
			}
			
			else
		System.out.println("Enter a book title: ");
		title=input.nextLine();
		list.add(title);
		System.out.println("Enter book author: ");
		author=input.nextLine();
		System.out.println("Enter the number of pages in the book: ");
		pages=input.nextInt();
		System.out.println("Enter the price of the book: ");
		price=input.nextDouble();
		System.out.println("Number of copies in stock: ");
		qty=input.nextInt();
		
		System.out.println("Book Added!");
		String decision = input.nextLine();
		System.out.println("");

		//Error if user inputs invalid book data
		if(author.equals("") || title.equals("") || pages <= 0 || price <= 0)
		{
			System.out.println("Error! Invalid Book Data!");
		}
		
		else
		{
			catalog.addBook(code, title, author, pages, price, qty, qtyLeft);
		}
	} while (redo = true);
	
	}
}