let pathParts = window.location.pathname.split("/");
let roomId = pathParts[pathParts.length - 2];

const joinMessage = { type: "join", data: `${roomId}`, pid: 0 };
let moveMessage = { type: "move", data: "up", pid: 0 };
const startMessage = { type: "start", data: `${roomId}`, pid: 0 };
const chatMessage = { type: "chat", data: "", pid: 0 };

const socket = new WebSocket("ws://127.0.0.1:3001", `${roomId}`);

let canvas = null;
let width = 800;
let height = 600;

let gameStarted = false;

let startButton = document.getElementById("startButton");
let chatSend = document.getElementById("chatSend");
let chatInput = document.getElementById("chatInput");

let playersReady = 0;

let gameBoardHandler = (event) => {
  canvas = document.getElementById("gameCanvas");
  let ctx = canvas.getContext("2d");
  ctx.clearRect(0, 0, width, height);
  ctx.fillStyle = "black";
  ctx.fillRect(0, 0, width, height);
  ctx.fillStyle = "white";

  let board = event.data;
  widthStep = width / board[0].length;
  heightStep = height / board.length;
  
  let coordsDiv = document.getElementById("snakeCoords");
  let sizeDiv = document.getElementById("snakeSize");

  if (event.headPosition && event.bodySize) {
    coordsDiv.innerText = `Coords: (${event.headPosition.x}, ${event.headPosition.y})`;
    sizeDiv.innerText = `Size: ${event.bodySize}`;
  }

  for (let i = 0; i < board.length; i++) {
    for (let j = 0; j < board[i].length; j++) {
      if (board[i][j].type === 0) {
        ctx.fillRect(
          j * widthStep + 1,
          i * heightStep + 1,
          widthStep - 2,
          heightStep - 2,
        );
      }
      if (board[i][j].type === 1) {
        ctx.fillStyle = "red";
        ctx.fillRect(
          j * widthStep + 1,
          i * heightStep + 1,
          widthStep - 2,
          heightStep - 2,
        );
        ctx.fillStyle = "white";
      }
      if (board[i][j].type === 2) {
        ctx.fillStyle = "red";
        ctx.fillRect(
          j * widthStep + 1,
          i * heightStep + 1,
          widthStep - 2,
          heightStep - 2,
        );
        ctx.fillStyle = "white";
      }
      if (board[i][j].type === 3) {
        ctx.fillStyle = "blue";
        ctx.fillRect(
          j * widthStep + 1,
          i * heightStep + 1,
          widthStep - 2,
          heightStep - 2,
        );
        ctx.fillStyle = "white";
      }
      if (board[i][j].type === 4) {
        ctx.fillStyle = "yellow";
        ctx.fillRect(
          j * widthStep + 1,
          i * heightStep + 1,
          widthStep - 2,
          heightStep - 2,
        );
        ctx.fillStyle = "white";
      }
      if (board[i][j].type === 5) {
        ctx.fillStyle = "black";
        ctx.fillRect(
          j * widthStep + 1,
          i * heightStep + 1,
          widthStep - 2,
          heightStep - 2,
        );
        ctx.fillStyle = "white";
      }
      if (board[i][j].type === 6) {
        ctx.fillStyle = "green";
        ctx.fillRect(
          j * widthStep + 1,
          i * heightStep + 1,
          widthStep - 2,
          heightStep - 2,
        );
        ctx.fillStyle = "white";
      }
    }
  }
};

let newUserHandler = (event) => {
  moveMessage.pid = event.data;
  startMessage.pid = event.data;
  chatMessage.pid = event.data;
  joinMessage.pid = event.data;
  socket.send(JSON.stringify(joinMessage));
};

socket.addEventListener("open", () => {
  console.log("Connected to server");
});

socket.addEventListener("message", (event) => {
  try {
    let msg = JSON.parse(event.data);
    if (msg.type === "gameBoard") {
      gameBoardHandler(msg);
    } else if (msg.type === "newUser") {
      newUserHandler(msg);
    } else if (msg.type === "chat") {
      const messages = document.getElementById("chatOutput");
      const messageElement = document.createElement("div");
      messageElement.innerText = `${msg.pid}: ${msg.data}`;
      messages.appendChild(messageElement);
    } else if (msg.type === "start") {
      gameStart();
      gameStarted = true;
    } else if (msg.type === "playerReady") {
      const messages = document.getElementById("chatOutput");
      const messageElement = document.createElement("div");
      messageElement.innerText = `Player ${msg.pid} is ready!`;
      messages.appendChild(messageElement);

      updatePlayerCount(1);
    } else if (msg.type === "playerJoined") {
      const messages = document.getElementById("chatOutput");
      const messageElement = document.createElement("div");
      messageElement.innerText = `Player ${msg.pid} has joined the game!`;
      messages.appendChild(messageElement);

      updateNumberPlayers(msg.numPlayers);
    } else if (msg.type === "restart") {
      const messages = document.getElementById("chatOutput");
      const messageElement = document.createElement("div");
      messageElement.innerText = `Player ${msg.pid} is the WINNER!`;
      messages.appendChild(messageElement);
      setTimeout(() => {
        //Redirect back to lobby after 10 seconds
        window.location.href = msg.url;
      }, 10000);
    }
  } catch (e) {
    console.log(e.message);
  }
});

document.addEventListener("keydown", (event) => {
  console.log(event.key);
  if (event.key === "ArrowUp") {
    moveMessage.data = "up";
    socket.send(JSON.stringify(moveMessage));
  }
  if (event.key === "ArrowDown") {
    moveMessage.data = "down";
    socket.send(JSON.stringify(moveMessage));
  }
  if (event.key === "ArrowLeft") {
    moveMessage.data = "left";
    socket.send(JSON.stringify(moveMessage));
  }
  if (event.key === "ArrowRight") {
    moveMessage.data = "right";
    socket.send(JSON.stringify(moveMessage));
  }
  if (event.key === "Enter") {
    if (!gameStarted) {
      sendChat();
    }
  }
});

startButton.addEventListener("click", () => {
  socket.send(JSON.stringify(startMessage));
});

chatSend.addEventListener("click", () => {
  sendChat();
});

let sendChat = () => {
  chatMessage.data = chatInput.value;
  socket.send(JSON.stringify(chatMessage));
  chatInput.value = "";
};

let gameStart = () => {
  let gameDiv = document.getElementById("game");
  canvas = document.createElement("canvas");
  canvas.id = "gameCanvas";
  canvas.width = width;
  canvas.height = height;
  gameDiv.appendChild(canvas);

  let spectateButton = document.createElement("button");
  spectateButton.id = "spectateButton";
  spectateButton.innerText = "Spectate Next Player";
  spectateButton.addEventListener("click", () => {
    socket.send(JSON.stringify({ type: "spectate", data: "" }));
  });
  gameDiv.appendChild(spectateButton);

  document.getElementById("chatInput").disabled = false;
};

let updatePlayerCount = (count) => {
  let playerCount = document.getElementById("playersStarted");
  playersReady += count;
  playerCount.innerText = `Players: ${playersReady}`;
};

let updateNumberPlayers = (count) => {
  let countDiv = document.getElementById("numPlayers");
  countDiv.innerText = `Number of players: ${count}`;
};
